/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.ui.hover;

import com.aptana.editor.common.hover.CustomBrowserInformationControl;
import com.aptana.editor.php.indexer.PHPGlobalIndexer;
import com.aptana.editor.php.internal.ui.hover.AbstractPHPTextHover;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Node;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org2.eclipse.php.internal.debug.core.zend.debugger.DefaultExpressionsManager;
import org2.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org2.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org2.eclipse.php.internal.debug.core.zend.model.PHPStackFrame;
import org2.eclipse.php.util.StringUtils;

public class PHPDebugHover
extends AbstractPHPTextHover {
    private IDebugModelPresentation modelPresentation;
    private ITextViewer textViewer;

    protected PHPDebugTarget getDebugTarget() {
        IAdaptable adaptable = DebugUITools.getDebugContext();
        if (adaptable instanceof PHPStackFrame) {
            PHPStackFrame stackFrame = (PHPStackFrame)adaptable;
            PHPDebugTarget debugTarget = (PHPDebugTarget)stackFrame.getDebugTarget();
            return debugTarget;
        }
        return null;
    }

    protected String getValue(PHPDebugTarget debugTarget, String variable) {
        DefaultExpressionsManager expressionManager = debugTarget.getExpressionManager();
        Expression expression = expressionManager.buildExpression(variable);
        debugTarget.getExpressionManager().getExpressionValue(expression, 1);
        expressionManager.update(expression, 1);
        String value = expression.getValue().getValueAsString();
        if (value != null && value.length() == 0) {
            value = "Empty";
        }
        return value;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        this.textViewer = textViewer;
        IStackFrame frame = PHPDebugHover.getFrame();
        if (frame != null) {
            return this.getHoverInfo(frame, this.isBrowserControlAvailable(textViewer), null, this.getEditor(), hoverRegion);
        }
        return null;
    }

    public static IStackFrame getFrame() {
        Object frame;
        IAdaptable adaptable = DebugUITools.getDebugContext();
        if (adaptable instanceof IStackFrame) {
            return (IStackFrame)adaptable;
        }
        if (adaptable != null && (frame = adaptable.getAdapter(PHPStackFrame.class)) instanceof IStackFrame) {
            return (IStackFrame)frame;
        }
        return null;
    }

    private String getVariableText(IVariable variable) {
        StringBuilder buffer = new StringBuilder();
        IDebugModelPresentation modelPresentation = this.getModelPresentation();
        buffer.append("<p>");
        String variableText = modelPresentation.getText((Object)variable);
        buffer.append(StringUtils.convertToHTMLContent((String)variableText));
        buffer.append("</p>");
        if (buffer.length() > 0) {
            return buffer.toString();
        }
        return null;
    }

    private IDebugModelPresentation getModelPresentation() {
        if (this.modelPresentation == null) {
            this.modelPresentation = DebugUITools.newDebugModelPresentation((String)"org2.eclipse.php.debug.core");
            this.modelPresentation.setAttribute("org.eclipse.debug.ui.displayVariableTypeNames", (Object)Boolean.TRUE);
        }
        return this.modelPresentation;
    }

    public String getHeader(Object element, IEditorPart editorPart, IRegion hoverRegion) {
        return null;
    }

    public String getDocumentation(Object element, IEditorPart editorPart, IRegion hoverRegion) {
        IStackFrame frame = (IStackFrame)element;
        IDocument document = this.textViewer.getDocument();
        if (document != null) {
            try {
                String variableName = document.get(hoverRegion.getOffset(), hoverRegion.getLength());
                try {
                    String testExp;
                    DBGpTarget xdebugTarget;
                    Node result;
                    List entries;
                    IVariable[] iVariableArray = frame.getVariables();
                    int n = iVariableArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IVariable v = iVariableArray[n2];
                        if (v.getName().equals(variableName)) {
                            return this.getVariableText(v);
                        }
                        ++n2;
                    }
                    String strippedVarName = variableName;
                    boolean shouldResolveConst = false;
                    if ((strippedVarName.startsWith("'") || strippedVarName.startsWith("\"")) && ((strippedVarName = strippedVarName.substring(1)).endsWith("'") || strippedVarName.endsWith("\""))) {
                        strippedVarName = strippedVarName.substring(0, strippedVarName.length() - 1);
                    }
                    if ((entries = PHPGlobalIndexer.getInstance().getIndex().getEntries(4, variableName)).isEmpty()) {
                        entries = !strippedVarName.equals(variableName) ? PHPGlobalIndexer.getInstance().getIndex().getEntries(4, strippedVarName) : PHPGlobalIndexer.getInstance().getIndex().getEntries(4, String.valueOf('\'') + variableName + '\'');
                    }
                    boolean bl = shouldResolveConst = !entries.isEmpty();
                    if (frame.getDebugTarget() instanceof DBGpTarget && (result = (xdebugTarget = (DBGpTarget)frame.getDebugTarget()).eval(testExp = strippedVarName.trim())) != null) {
                        DBGpVariable tempVar = new DBGpVariable(xdebugTarget, result, "0");
                        if (tempVar.getName().length() == 0) {
                            tempVar.setFullName(strippedVarName);
                        }
                        if (shouldResolveConst || tempVar.getValue() != null && !strippedVarName.equals(tempVar.getValue().getValueString())) {
                            return this.getVariableText(tempVar);
                        }
                    }
                }
                catch (DebugException debugException) {
                    return null;
                }
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        return null;
    }

    public void populateToolbarActions(ToolBarManager tbm, CustomBrowserInformationControl iControl) {
    }
}

